function exportModelData(model_filename)
if nargin<1
    [filename, pathname] = uigetfile('*.aam_dat', 'Pick a Model file');
    if isequal(filename,0) || isequal(pathname,0)
        disp('User pressed cancel')
    else
        disp(['User selected ', fullfile(pathname, filename)]);
        model = load([pathname, filesep, filename], '-mat');
    end
else
    if exist(model_filename, 'file')
        model = load(model_filename, '-mat');
    else
        return;
    end
end

if ~isfield(model, 'aam');
    fprintf('WARNING: no field AAM in selected model, exiting\n');
    return;
end
model = model.aam;
prompt={'Enter your user initials:'};
name='User Identifier Input';
numlines=1;
defaultanswer={'abc'};
author=inputdlg(prompt,name,numlines,defaultanswer);

[xlsfilename, xlspathname] = uiputfile('*.xls', 'Pick an Excel-file');
if isequal(xlsfilename,0) || isequal(xlspathname,0)
    disp('User pressed cancel')
    return;
else
    disp(['User selected ', fullfile(xlspathname, xlsfilename)])
end
%[p, xlsfilename, ext, vers] = fileparts(xlsfilename);
%xlsfilename = [xlsfilename, '_userid_', answer{1}, ext];
[geninfosheet, pmsheets, shapepcsheets, apppcsheets, pcsheets] = convertModel2Cell(model, author);
[success, message] = xlswrite([xlspathname, filesep, xlsfilename], geninfosheet, 'Gen. Proj. Info.');
for i=1:length(pmsheets)
    sheet = pmsheets{i};
    [success, message] = xlswrite([xlspathname, filesep, xlsfilename], sheet, ['PM Info. ', num2str(i)]);
end
for i=1:length(shapepcsheets)
    sheet = shapepcsheets{i};
    [success, message] = xlswrite([xlspathname, filesep, xlsfilename], sheet, ['Shape PC Info. ', num2str(i)]);
end
for i=1:length(apppcsheets)
    sheet = apppcsheets{i};
    [success, message] = xlswrite([xlspathname, filesep, xlsfilename], sheet, ['App. PC Info. ', num2str(i)]);
end

for i=1:length(pcsheets)
    sheet = pcsheets{i};
    [success, message] = xlswrite([xlspathname, filesep, xlsfilename], sheet, ['PC Vectors', num2str(i)]);
end
%%%%%
%
%%%%%
function [geninfosheet, pmsheets, shapepcsheets, apppcsheets, pcsheets] = convertModel2Cell(model, author)
pdmfile = [pwd, filesep, get(model, 'modelDirec'), filesep, 'mod_pdm.mat'];
if exist(pdmfile, 'file')
    fprintf(' - loading pdm from disk\n');
    pdm = load(pdmfile);
    pdm = pdm.pdm;
    model = set(model, 'pdm', pdm);
end
geninfosheet = constructGenInfoSheet(model, author);
pmsheets = constructPMInfoSheet(model);
shapepcsheets = constructShapePCInfoSheet(model);
apppcsheets = constructAppPCInfoSheet(model);
pcsheets = constructPCInfoSheet(model);
return;
