function pmsheets = constructAPPPCInfoSheet(model)

pmsheets = {};
sfamfile = [pwd, filesep, get(model,'modelDirec'), filesep, 'mod_sfam.mat'];
if ~exist(sfamfile, 'file')
    return
end
sfam = load(sfamfile);
sfam = sfam.sfam;

pdm = get(model, 'pdm');

if isempty(pdm)
    return;
end

if isempty(sfam)
    return;
end

sheet2 = {};
%sheet2 = makePMInfoSheetHeader(model);
imagenames = get(model, 'imageFilenames');
imagedir = 'Cropped';

template = get(model, 'PointModelTemplate');
templatename = get(template, 'name');
temppts = get(template, 'pts');
temppts = temppts(:);
numsheets = ceil(length(temppts)/250);
pmsheets = {};
for i=1:numsheets
    pmsheets{i} = {};
end


[templatepath, templatename, ext, vers] = fileparts(templatename);

% Point Model Directory Info
PMDirectory = ['PointModels', filesep, templatename];
% Get the point model names
pmfiles = dir([PMDirectory, filesep, '*_pm.mat']);
pmfiles = {pmfiles.name};
N = size(sheet2,1);
N = 0;
waitbar_h = waitbar(0, 'Exporting PC values...');
for i=1:length(imagenames)
    waitbar(i/length(imagenames), waitbar_h);
    sheet_num = 1;
    indx = 2;
    sheet = pmsheets{sheet_num};
    sheet{N+i, 1} = [imagenames{i}];    
    [pmfilename] = checkPMExist(pmfiles, imagenames{i});
    
    if isempty(pmfilename)
        sheet{N+i, 2} = 'No point model found';
    else
        %sheet2{N+i, indx} = [pmfilename];
        pts = load([PMDirectory, filesep, pmfilename]);
        pts = pts.pts;
        if length(pts) ~= length(temppts)
            fprintf(' - found an invalid point model %s filling with zeros.\n', pmfilename);
            b = zeros(length(temppts),1);
        else
            I = imread([imagedir, filesep, imagenames{i}]);
            if isfield(sfam, 'boundary_index')
                ptsx=pts(1:2:end);
                ptsy=pts(2:2:end);
                boundary_index = sfam.boundary_index;
                if ~isempty(boundary_index)
                    if iscell(boundary_index)
                        mask  = zeros(size(I,1), size(I,2));
                        for cc=1:length(boundary_index)
                            mask_x = ptsx(boundary_index{cc});
                            mask_y = ptsy(boundary_index{cc});
                            b = roipoly(I, mask_x, mask_y);
                            mask = mask | b;
                        end
                        mask = uint8(mask);
                        for p=1:size(I,3)
                            I(:,:,p) = I(:,:,p).*mask;
                        end

                    end
                end
            end
            msiz = sfam.siz;
            [wimg] = warp_to_mean_shape(pts, sfam.ompts, I, [], sfam.critical_triangle_expansion , [], [msiz(2),msiz(1),msiz(3)],[]);
            %imagesc(uint8(wimg))

            % in case you want to see the mean image.
            %img2=reshape(sfam.Am, [msiz(2) msiz(1) msiz(3)]);
            %imagesc(uint8(img2))
            b = sfam.P'*(wimg(:) - sfam.Am);
            reconI = sfam.Am + sfam.P*b;
            reconI=reshape(reconI, [msiz(2) msiz(1) msiz(3)]);
            figure(1);
            clf;
            subplot(1,2,1); imagesc(uint8(wimg)); axis image ij;
            title('Original Image');
            subplot(1,2,2); imagesc(uint8(reconI)); axis image ij;
            title('Reconstructed Image');
            pause(.01);
            
        end
        for ii=1:length(b)
            if mod(ii,250)==0
                pmsheets{sheet_num} = sheet;
                sheet_num = sheet_num+1;
                sheet = pmsheets{sheet_num};
                indx = 1;
            end
            sheet{N+i, indx} = b(ii);
            indx = indx +1;
        end
    end
    pmsheets{sheet_num} = sheet;
end
close(waitbar_h);
return;
%%%%%
%
%
%%%%%
function [pmfilename] = checkPMExist(pmfiles, imagename)
pmfilename = [];
[imagepath, imagename, ext, vers] = fileparts(imagename);
for i=1:length(pmfiles)
    pmfile = pmfiles{i};
    if length(pmfile)>2
        [pmfilepath, pmfile, ext, vers] = fileparts(pmfile);
        pmfile = pmfile(1:end-3);
        if strcmp(pmfile, imagename)
            pmfilename = pmfiles{i};
        end
    end
end

function sheet2 = makePMInfoSheetHeader(model)
sheet2 = {};
% Project Stuff
projectname = pwd;
[projectdir, projectname, ext, vers] = fileparts(projectname);
sheet2{end+1, 1} = 'Project Name';
sheet2{end, 2} = projectname;
sheet2{end+1, 1} = 'Project Directory';
sheet2{end, 2} = projectdir;
sheet2{end+1, 1} = '';
% Processed Images Directory
sheet2{end+1, 1} = 'Processed Images Directory';
imagedir = get(model, 'imageDirectory');
sheet2{end, 2} = imagedir;
template = get(model, 'PointModelTemplate');
templatename = get(template, 'name');
[templatepath, templatename, ext, vers] = fileparts(templatename);
% Point Model Directory Info
PMDirectory = ['PointModels', filesep, templatename];
% Get the point model names
pmfiles = dir(PMDirectory);
pmfiles = {pmfiles.name};
sheet2{end+1, 1} = '';
sheet2{end+1, 1} = 'Point Model Directory';
sheet2{end, 2} = PMDirectory;
sheet2{end+1, 1} = '';
% Processed Images Directory
sheet2{end+1, 1} = 'Image Number';
sheet2{end, 2} = 'Processed Image Name';
sheet2{end, 3} = 'Point Model Filename';
sheet2{end, 4} = 'XY-Values';