function FigureCreator(varargin)
% function FigureCreator(varargin)
%
% Example 1:
% FigureCreator;
%
% Example 2:
% FigureCreator(<your_model_directory>);
%
%
% Dr. A. I. Hanna (2007) CMP, UEA.
error(nargchk(0,inf,nargin));
ad.modeldir = '';
if mod(length(varargin),2) ~= 0
    % input args have not com in pairs, woe is me
    error('Arguments to FigureCreator must come param/value in pairs.')
end
for i=1:2:length(varargin)
    switch lower(varargin{i})
        case 'modeldir'
            ad.modeldir = varargin{i+1};
        otherwise
            error(['Unknown parameter name passed to FigureCreator.  Name was ' varargin{i}])
    end
end
% Open, move, and get the handles from the figure file.
fig = openfig(mfilename, 'reuse');
% Move the gui and then show it, rather than have it jump all over the
% place.
movegui(fig, 'center');
set(fig, 'visible', 'on');
handles = guihandles(fig);

set(fig, 'Color', get(handles.figgenpanel, 'BackgroundColor'))

% Set all the callback functions
set(handles.fig1_btn, 'callback', {@doFigure1});
set(handles.fig2_btn, 'callback', {@doFigure2});
set(handles.fig3_btn, 'callback', {@doFigure3});
set(handles.fig4_btn, 'callback', {@doFigure4});
set(handles.movie1_btn, 'callback', {@doMovie1});

% Initialize the application data structure
ad.figMain = fig;
ad.handles = handles;
setappdata(0,'FigureCreatorData',ad);
try
    uiwait(fig);
catch
    if ishandle(fig)
        delete(fig)
    end
end
return;
%%%
%
%%%
function doFigure1(fig1, evd) %#ok<INUSD,INUSD>
ad = getappdata(0, 'FigureCreatorData');
delete(ad.figMain);
figure_1_points_around_leaf;
setappdata(0, 'FigureCreatorData', ad);
return;
%%%
%
%%%
function doFigure2(fig2, evd) %#ok<INUSD,INUSD>
ad = getappdata(0, 'FigureCreatorData');
delete(ad.figMain);
if ~isempty(ad.modeldir)
    answer = questdlg('Do you want to use the current model?', 'Use Model','Yes', 'No', 'Yes');
    if isempty(answer) || strcmpi(answer, 'no')
        figure_2_pc_effects;
    else
        figure_2_pc_effects(ad.modeldir);
    end
else
	figure_2_pc_effects;
end
setappdata(0, 'FigureCreatorData', ad);
return;
%%%
%
%%%
function doFigure3(fig2, evd) %#ok<INUSD,INUSD>
ad = getappdata(0, 'FigureCreatorData');
delete(ad.figMain);
figure_compare_selected_pcs;
setappdata(0, 'FigureCreatorData', ad);
return;
%%%
%
%%%
function doFigure4(fig2, evd) %#ok<INUSD,INUSD>
ad = getappdata(0, 'FigureCreatorData');
delete(ad.figMain);
if ~isempty(ad.modeldir)
    answer = questdlg('Do you want to use the current model?', 'Use Model','Yes', 'No', 'Yes');
    if isempty(answer) || strcmpi(answer, 'no')
        figure_show_original_and_modelled;
    else
        figure_show_original_and_modelled(ad.modeldir);
    end
else
	figure_show_original_and_modelled;
end
setappdata(0, 'FigureCreatorData', ad);
return;

%%%
%
%%%
function doMovie1(movie1, evd) %#ok<INUSD,INUSD>
ad = getappdata(0, 'FigureCreatorData');
delete(ad.figMain);
if ~isempty(ad.modeldir)
    answer = questdlg('Do you want to use the current model?', 'Use Model','Yes', 'No', 'Yes');
    if isempty(answer) || strcmpi(answer, 'no')
        ShowEllipseWalk;
    else
        ShowEllipseWalk('modelDir', ad.modeldir);
    end
else
	ShowEllipseWalk;
end
setappdata(0, 'FigureCreatorData', ad);
return;
