function varargout = plotTemplate(varargin)

error(nargchk(0,inf,nargin));
template = [];
axish = [];
linecol = [1 1 1];
edgecol = 'r';
facecol = 'y';

if mod(length(varargin),2) ~= 0
    % input args have not com in pairs, woe is me
    error(['Arguments to ', mfilename, ' must come param/value in pairs.'])
end
for i=1:2:length(varargin)
    switch lower(varargin{i})
        case 'template'
            template = varargin{i+1};
        case 'parent'
            axish = varargin{i+1};
        otherwise
            error(['Unknown parameter name passed to ', mfilename, '.  Name was ' varargin{i}])
    end
end
if isempty(template)
   error('Template parameter needed');
end
if isempty(axish)
    axish = gca;
end
pts = get(template, 'pts');
edges = get(template, 'loops');
I = get(template, 'image');

if iscell(edges)
    if ~isempty(edges)
        edges = edges{1};
    else
        edges = [];
    end
end
hold(axish, 'on');
imagesc(I, 'Parent', axish');
edges_h = [];
for i=1:size(edges,1)
    edges_h = cat(2, edges_h, plot(axish, [pts(1, edges(i,1)), pts(1, edges(i,2))], [pts(2, edges(i,1)), pts(2, edges(i,2))], 'Color', linecol));
end
pts_h = plot(axish, pts(1,:), pts(2,:), 'o', 'MarkerEdgeColor', edgecol, 'MarkerFaceColor', facecol);
axis(axish, 'image', 'ij');
template_h.edges_h = edges_h;
template_h.pts_h = pts_h;
varargout{1} = template_h;
return