%
% function [a] = set(a, varargin)
%
% Notice that because MATLAB doesn't support passing by reference it is
% necessary to copy over the original class. 
%
% i.e. pm = smtoolbox; 
%      pm = set(pm, 'arg', 'hi');
% 
% Dr. A. I. Hanna 2005
function [a] = set(a, varargin)
    prop_argin =  varargin;
    while length(prop_argin) >=2
        prop = prop_argin{1};
        val = prop_argin{2};
        prop_argin = prop_argin(3:end);
        switch prop
            case 'image'
                a.image = val;
            case 'pts'
                a.pts = val;
            case 'primaries'
                a.primaries = val;
			case 'imageName'
				a.imageName = val;
			case 'imageDir'
				a.imageDir = val;
			case 'name'
				a.name = val;
			case 'direc'
				a.direc = val;
			case 'loops'
				a.loops = val;
			case 'closedloops'
				a.closedloops = val;
			case 'subsets'
				a.subsets = val;
			case 'labels'
				a.labels = val;
            otherwise
                error(['PointModelTemplate Properties: ', prop]);
        end
    end
    return;
