%
% function [a] = get(a, prop)
%
% Overrides the get method for the SMToolbox Class.
%
% i.e. pm = smtoolbox; val = get(pm, 'arg');
% 
% Dr. A. I. Hanna 2005
function [val] = get(a, prop)
    switch prop
        case 'Image'
            val = a.Image;
        case 'pts'
            val = a.pts;
        case 'elements'
            val = a.elements;
        case 'imageDirectory'
            val = a.imageDirectory;
        case 'imageFilenames'
            val = a.imageFilenames;
        case 'CurrentEntity'
            val = a.currentEntity;
       case 'CurrentEntityNumber'
            val = a.currentEntityNumber;
        case 'modelName'
            val = a.modelName;
        case 'modelDirec'
            val = a.modelDirec;
        case 'PointModelTemplate'
            val = a.PointModelTemplate;
        case 'activeElements'
            val = a.activeElements;
        case 'completeElements'
            val = a.completeElements;
        case 'procrustesParams'
            val = a.procrustesParams;
        case 'pdm'
            val = a.pdm;
        case 'rootDir'
            val = a.rootDir;
        case 'pdmDirec'
            val = a.pdmDirec;
        case 'pdmName'
            val = a.pdmName;
        case 'sfamDirec'
            val = a.sfamDirec;
        case 'sfamName'
            val = a.sfamName;
        case 'pointset'
            val = a.pointset;
        case 'imageset'
            val = a.imageset;
        case 'pointindices'
            val = a.pointindices;
        case 'am_imagenames'
            val = a.am_imagenames;
        case 'options'
            val = a.options;
        otherwise
            error([prop, ' is not a valid property name of Appearance Entity']);
    end            
    return;
