function [B, sorted_edge] = segment_katrin_white_on_black(I)
[M, N] = size(I);
level = 0.15*(M*N);




Ig = rgb2gray(I);
B = sieve2d(Ig, level);
B = B==max(B(:));
B = imclose(B, strel('disk', 10));


%imagesc(B);

[counts, X] = imhist(Ig);
lim = [40 130];
X = X(lim(1):lim(2));
counts = counts(lim(1):lim(2));
[val, in] = min(counts);
thr = X(in(1));
B = Ig>thr;
B = bwfill(B, 'holes');
B = imclearborder(B);
E = bwboundaries(B);
sorted_edge = E{1};
return;







