%%%%%%
%
%
%
%%%%%%
function OrderAugmentedPointModels
augmentdir = [pwd, filesep, 'Data'];
augmentinfoname = [augmentdir filesep, 'augment_info.mat'];
if ~exist(augmentinfoname);
    fprintf('There is no augmentation information file in <project_dir>/Data directory\n');
    return;
end
augment_info = load(augmentinfoname);
augment_info = augment_info.augment_info;
PMORDERINFO_XLS = {};
for i=1:length(augment_info)
    [prjpath, prjname, prjext, prjvers] = fileparts(augment_info(i).projectdir);
    order = OrderPointModels('ListString', {augment_info(i).pmfiles.filename}, 'ProjectName', prjname);
    augment_info(i).ordered_pmfiles = order;
    PMORDERINFO_XLS{1,i} = prjname;
    for ii=1:length(order)
        PMORDERINFO_XLS{ii+1,i} = order{ii};
    end
end
[SUCCESS,MESSAGE]=xlswrite([augmentdir filesep, 'PMORDERINFO_XLS.xls'], PMORDERINFO_XLS, 'PM Ordering');
save([augmentdir, filesep, 'augment_info'], 'augment_info');
