%%%%%%%%%%%%%%%%%%%%
%
% Check that the directory is valid, i.e. it has Original and Cropped
%
%%%%%%%%%%%%%%%%%%%%
function [validDir] = checkDir(d, handles)
validDir = 0;
[cwd, direc] = fileparts(d);
if strcmp(direc(1:4), 'PRJ_') & exist([pwd, filesep, 'Cropped'], 'dir') & exist([pwd, filesep, 'Original'], 'dir')
    validDir = 1;
    set([handles.imageProcBtn, handles.autoPlaceBtn, ...
        handles.currentModelTxt,handles.newModelBtn, handles.pmEditorBtn, ...
        handles.modelGeneratorBtn, handles.pdmWalkBtn, handles.view_shape_space_btn], 'Enable', 'on');
else
    set([handles.imageProcBtn, handles.autoPlaceBtn, ...
        handles.currentModelTxt, handles.pmEditorBtn, handles.modelGeneratorBtn, ...
        handles.pdmWalkBtn, handles.view_shape_space_btn], 'Enable', 'off');
end
set(handles.cwdTxt, 'String', cut_string(direc));
set(handles.matlabFilesTxt, 'String', cut_string(which('AAMToolbox')));
return;